<?php
require_once __DIR__ . '/../lib/db.php';
require_once __DIR__ . '/../partials/header.php';
require_role('admin');

if ($_SERVER['REQUEST_METHOD']==='POST') {
  csrf_check();
  $name = trim($_POST['name'] ?? '');
  $address = trim($_POST['address'] ?? '');
  $phone = trim($_POST['phone'] ?? '');
  if ($name) {
    $db->prepare("INSERT INTO branches(name,address,phone,created_at) VALUES (?,?,?,?)")
       ->execute([$name,$address,$phone,now_iso()]);
  }
  header('Location: /admin/branches.php'); exit;
}

$rows = $db->query("SELECT * FROM branches ORDER BY id DESC")->fetchAll(PDO::FETCH_ASSOC);
?>
<h4>Sucursales</h4>
<div class="row g-3">
  <div class="col-md-5">
    <div class="card"><div class="card-body">
      <form method="post">
        <input type="hidden" name="_csrf" value="<?=h(csrf_token())?>">
        <div class="mb-2"><label class="form-label">Nombre</label><input class="form-control" name="name" required></div>
        <div class="mb-2"><label class="form-label">Dirección</label><input class="form-control" name="address"></div>
        <div class="mb-3"><label class="form-label">Teléfono</label><input class="form-control" name="phone"></div>
        <button class="btn btn-primary">Agregar</button>
      </form>
    </div></div>
  </div>
  <div class="col-md-7">
    <div class="table-responsive">
      <table class="table table-sm table-striped">
        <thead><tr><th>ID</th><th>Nombre</th><th>Dirección</th><th>Tel</th></tr></thead>
        <tbody>
        <?php foreach($rows as $r): ?>
          <tr><td><?=h($r['id'])?></td><td><?=h($r['name'])?></td><td><?=h($r['address'])?></td><td><?=h($r['phone'])?></td></tr>
        <?php endforeach; ?>
        </tbody>
      </table>
    </div>
  </div>
</div>
<?php require_once __DIR__ . '/../partials/footer.php'; ?>
