<?php
require_once __DIR__ . '/../lib/db.php';
require_once __DIR__ . '/../partials/header.php';
require_role('admin');

$msg='';
if ($_SERVER['REQUEST_METHOD']==='POST') {
  csrf_check();
  $tok = trim($_POST['token'] ?? '');
  // store token in settings
  $db->prepare("INSERT INTO settings(k,v) VALUES ('PRISMA_BEARER_TOKEN_DB', ?) ON CONFLICT(k) DO UPDATE SET v=excluded.v")->execute([$tok]);
  $msg = $tok ? 'Token guardado.' : 'Token borrado.';
}

$st = $db->prepare("SELECT v FROM settings WHERE k='PRISMA_BEARER_TOKEN_DB'");
$st->execute();
$cur = (string)($st->fetchColumn() ?: '');
?>
<h4>Prisma Token (Bearer)</h4>
<?php if($msg): ?><div class="alert alert-success"><?=h($msg)?></div><?php endif; ?>

<div class="card"><div class="card-body" style="max-width:760px">
  <p class="text-muted mb-2">
    Prisma requiere un <b>Bearer Token</b> en la cabecera <code>Authorization</code>.
    Pegalo acá (se guarda en SQLite). Recomendado: pegar token de Sandbox y luego el de Producción.
  </p>
  <form method="post">
    <input type="hidden" name="_csrf" value="<?=h(csrf_token())?>">
    <div class="mb-2">
      <label class="form-label">Bearer Token</label>
      <textarea class="form-control" name="token" rows="5" placeholder="eyJhbGciOi..."><?=h($cur)?></textarea>
      <div class="form-text">Si dejás vacío y guardás, se borra.</div>
    </div>
    <button class="btn btn-primary">Guardar</button>
    <a class="btn btn-outline-secondary" href="/admin/settings.php">Volver</a>
  </form>
</div></div>

<?php require_once __DIR__ . '/../partials/footer.php'; ?>
