<?php
require_once __DIR__ . '/../lib/db.php';
require_once __DIR__ . '/../partials/header.php';
require_role('admin');

$msg='';
if ($_SERVER['REQUEST_METHOD']==='POST') {
  csrf_check();
  foreach(['BASE_URL','DEFAULT_CHANNEL','DEFAULT_ORIGIN'] as $k){
    $v = trim($_POST[$k] ?? '');
    if ($v !== '') {
      $db->prepare("INSERT INTO settings(k,v) VALUES (?,?) ON CONFLICT(k) DO UPDATE SET v=excluded.v")->execute([$k,$v]);
    }
  }
  $msg='Guardado (nota: BASE_URL real se configura en config.php)';
}
$settings = [];
foreach($db->query("SELECT k,v FROM settings") as $r){ $settings[$r['k']]=$r['v']; }
?>
<h4>Settings</h4>
<?php if($msg): ?><div class="alert alert-success"><?=h($msg)?></div><?php endif; ?>
<div class="card"><div class="card-body" style="max-width:720px">
  <form method="post">
    <input type="hidden" name="_csrf" value="<?=h(csrf_token())?>">
    <div class="mb-2">
      <label class="form-label">DEFAULT_CHANNEL</label>
      <input class="form-control" name="DEFAULT_CHANNEL" value="<?=h($settings['DEFAULT_CHANNEL'] ?? DEFAULT_CHANNEL)?>">
    </div>
    <div class="mb-2">
      <label class="form-label">DEFAULT_ORIGIN</label>
      <input class="form-control" name="DEFAULT_ORIGIN" value="<?=h($settings['DEFAULT_ORIGIN'] ?? DEFAULT_ORIGIN)?>">
    </div>
    <div class="mb-3">
      <label class="form-label">BASE_URL (informativo)</label>
      <input class="form-control" name="BASE_URL" value="<?=h($settings['BASE_URL'] ?? BASE_URL)?>">
      <div class="form-text">Recomendado configurar BASE_URL real en config.php o variable de entorno.</div>
    </div>
    <button class="btn btn-primary">Guardar</button>
  </form>
</div></div>
<?php require_once __DIR__ . '/../partials/footer.php'; ?>
