<?php
require_once __DIR__ . '/../lib/db.php';
require_once __DIR__ . '/../partials/header.php';
require_role('admin');

if ($_SERVER['REQUEST_METHOD']==='POST') {
  csrf_check();
  $branch = (int)($_POST['branch_id'] ?? 0);
  $code = trim($_POST['code'] ?? '');
  $name = trim($_POST['name'] ?? '');
  if ($branch && $code) {
    $db->prepare("INSERT INTO terminals(branch_id,code,name,is_active,created_at) VALUES (?,?,?,?,?)")
       ->execute([$branch,$code,$name,1,now_iso()]);
  }
  header('Location: /admin/terminals.php'); exit;
}

$branches = $db->query("SELECT id,name FROM branches ORDER BY name")->fetchAll(PDO::FETCH_ASSOC);
$rows = $db->query("SELECT t.*, b.name as branch_name FROM terminals t JOIN branches b ON b.id=t.branch_id ORDER BY t.id DESC")->fetchAll(PDO::FETCH_ASSOC);
?>
<h4>Cajas / Terminales</h4>
<div class="row g-3">
  <div class="col-md-5">
    <div class="card"><div class="card-body">
      <form method="post">
        <input type="hidden" name="_csrf" value="<?=h(csrf_token())?>">
        <div class="mb-2">
          <label class="form-label">Sucursal</label>
          <select class="form-select" name="branch_id" required>
            <option value="">—</option>
            <?php foreach($branches as $b): ?>
              <option value="<?=h($b['id'])?>"><?=h($b['name'])?></option>
            <?php endforeach; ?>
          </select>
        </div>
        <div class="mb-2"><label class="form-label">Código</label><input class="form-control" name="code" placeholder="CAJA002" required></div>
        <div class="mb-3"><label class="form-label">Nombre</label><input class="form-control" name="name" placeholder="Caja 2"></div>
        <button class="btn btn-primary">Agregar</button>
      </form>
    </div></div>
  </div>
  <div class="col-md-7">
    <div class="table-responsive">
      <table class="table table-sm table-striped">
        <thead><tr><th>ID</th><th>Sucursal</th><th>Código</th><th>Nombre</th></tr></thead>
        <tbody>
        <?php foreach($rows as $r): ?>
          <tr><td><?=h($r['id'])?></td><td><?=h($r['branch_name'])?></td><td><?=h($r['code'])?></td><td><?=h($r['name'])?></td></tr>
        <?php endforeach; ?>
        </tbody>
      </table>
    </div>
  </div>
</div>
<?php require_once __DIR__ . '/../partials/footer.php'; ?>
