<?php
require_once __DIR__ . '/../lib/db.php';
require_once __DIR__ . '/../partials/header.php';
require_role('admin');

$msg = '';
if ($_SERVER['REQUEST_METHOD']==='POST') {
  csrf_check();
  $email = trim($_POST['email'] ?? '');
  $name  = trim($_POST['name'] ?? '');
  $pass  = $_POST['password'] ?? '';
  $role  = trim($_POST['role'] ?? 'cashier');
  $branch = $_POST['branch_id'] !== '' ? (int)$_POST['branch_id'] : null;

  if ($email && $name && $pass) {
    $hash = password_hash_cf($pass);
    $st = $db->prepare("INSERT INTO users(email,name,password_hash,role,branch_id,is_active,created_at) VALUES (?,?,?,?,?,?,?)");
    $st->execute([$email,$name,$hash,$role,$branch,1,now_iso()]);
    $msg = 'Usuario creado';
  } else {
    $msg = 'Completar email, nombre y clave';
  }
}

$branches = $db->query("SELECT id,name FROM branches ORDER BY name")->fetchAll(PDO::FETCH_ASSOC);
$rows = $db->query("SELECT u.*, b.name as branch_name FROM users u LEFT JOIN branches b ON b.id=u.branch_id ORDER BY u.id DESC")->fetchAll(PDO::FETCH_ASSOC);
?>
<h4>Usuarios</h4>
<?php if($msg): ?><div class="alert alert-info"><?=h($msg)?></div><?php endif; ?>
<div class="row g-3">
  <div class="col-md-5">
    <div class="card"><div class="card-body">
      <form method="post">
        <input type="hidden" name="_csrf" value="<?=h(csrf_token())?>">
        <div class="mb-2"><label class="form-label">Email</label><input class="form-control" name="email" required></div>
        <div class="mb-2"><label class="form-label">Nombre</label><input class="form-control" name="name" required></div>
        <div class="mb-2"><label class="form-label">Clave</label><input class="form-control" name="password" type="password" required></div>
        <div class="mb-2">
          <label class="form-label">Rol</label>
          <select class="form-select" name="role">
            <option value="cashier">cashier</option>
            <option value="admin">admin</option>
          </select>
        </div>
        <div class="mb-3">
          <label class="form-label">Sucursal (solo cashier)</label>
          <select class="form-select" name="branch_id">
            <option value="">—</option>
            <?php foreach($branches as $b): ?>
              <option value="<?=h($b['id'])?>"><?=h($b['name'])?></option>
            <?php endforeach; ?>
          </select>
        </div>
        <button class="btn btn-primary">Crear</button>
      </form>
    </div></div>
  </div>
  <div class="col-md-7">
    <div class="table-responsive">
      <table class="table table-sm table-striped">
        <thead><tr><th>ID</th><th>Email</th><th>Nombre</th><th>Rol</th><th>Sucursal</th><th>Activo</th></tr></thead>
        <tbody>
        <?php foreach($rows as $r): ?>
          <tr>
            <td><?=h($r['id'])?></td><td><?=h($r['email'])?></td><td><?=h($r['name'])?></td><td><?=h($r['role'])?></td>
            <td><?=h($r['branch_name'] ?? '-')?></td><td><?=h($r['is_active'])?></td>
          </tr>
        <?php endforeach; ?>
        </tbody>
      </table>
    </div>
  </div>
</div>
<?php require_once __DIR__ . '/../partials/footer.php'; ?>
