<?php
require_once __DIR__ . '/lib/db.php';
require_once __DIR__ . '/lib/prisma.php';
require_once __DIR__ . '/lib/receipts.php';
require_once __DIR__ . '/partials/header.php';

$user = $_SESSION['user'];
$branchId = (int)($user['branch_id'] ?? 0);
if (!$branchId && $user['role'] !== 'admin') {
  echo "<div class='alert alert-warning'>Tu usuario no tiene sucursal asignada. Pedile al admin que lo asigne.</div>";
}

$terminals = [];
if ($branchId) {
  $st = $db->prepare("SELECT id, code, name FROM terminals WHERE branch_id=? AND is_active=1 ORDER BY code");
  $st->execute([$branchId]);
  $terminals = $st->fetchAll(PDO::FETCH_ASSOC);
}

$debts = null;
$error = '';

if (isset($_POST['action']) && $_POST['action']==='consult') {
  csrf_check();
  try {
    $payload = [
      "consumer_id" => trim($_POST['consumer_id'] ?? ''),
      "channel" => DEFAULT_CHANNEL,
      "ip_address" => $_SERVER['REMOTE_ADDR'] ?? '0.0.0.0',
      "terminal" => trim($_POST['terminal_code'] ?? ''),
      "origin" => DEFAULT_ORIGIN,
      "timestamp" => now_iso(),
      "client" => [
        "document_number" => trim($_POST['document_number'] ?? ''),
        "document_type" => trim($_POST['document_type'] ?? 'DNI'),
      ]
    ];
    $res = prisma_debts_details($payload);
    $debts = $res['debts'] ?? [];
    $_SESSION['_last_debts_payload'] = $payload;
    $_SESSION['_last_debts_raw'] = json_encode($res, JSON_UNESCAPED_UNICODE);
  } catch(Exception $e){
    $error = $e->getMessage();
  }
}

if (isset($_POST['action']) && $_POST['action']==='charge') {
  csrf_check();
  try {
    $terminalId = (int)($_POST['terminal_id'] ?? 0);
    if (!$terminalId) throw new Exception("Seleccioná una caja/terminal.");
    $ts = now_iso();
    $receiptNo = next_receipt_no($db, $terminalId);

    $r = [
      'receipt_no' => $receiptNo,
      'ts' => $ts,
      'branch_id' => $branchId ?: 1,
      'terminal_id' => $terminalId,
      'cashier_user_id' => (int)$user['id'],
      'document_type' => trim($_POST['document_type'] ?? 'DNI'),
      'document_number' => trim($_POST['document_number'] ?? ''),
      'company_id' => trim($_POST['company_id'] ?? ''),
      'company_name' => trim($_POST['company_name'] ?? ''),
      'category_id' => trim($_POST['category_id'] ?? ''),
      'category_name' => trim($_POST['category_name'] ?? ''),
      'customer_id' => trim($_POST['customer_id'] ?? ''),
      'invoice_id' => trim($_POST['invoice_id'] ?? ''),
      'barcode' => trim($_POST['barcode'] ?? ''),
      'amount' => (float)($_POST['amount'] ?? 0),
      'currency' => trim($_POST['currency'] ?? 'ARS'),
      'due_date' => trim($_POST['due_date'] ?? ''),
      'status' => 'COBRADO_INTERNO',
      'raw_debt_json' => $_SESSION['_last_debts_raw'] ?? '',
      'raw_confirm_json' => '',
      'created_at' => $ts,
    ];
    $r['security_code'] = security_code($r);

    $st = $db->prepare("INSERT INTO receipts
(receipt_no,ts,branch_id,terminal_id,cashier_user_id,document_type,document_number,company_id,company_name,category_id,category_name,customer_id,invoice_id,barcode,amount,currency,due_date,status,security_code,raw_debt_json,raw_confirm_json,created_at)
VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
    $st->execute([
      $r['receipt_no'],$r['ts'],$r['branch_id'],$r['terminal_id'],$r['cashier_user_id'],$r['document_type'],$r['document_number'],
      $r['company_id'],$r['company_name'],$r['category_id'],$r['category_name'],$r['customer_id'],$r['invoice_id'],$r['barcode'],
      $r['amount'],$r['currency'],$r['due_date'],$r['status'],$r['security_code'],$r['raw_debt_json'],$r['raw_confirm_json'],$r['created_at']
    ]);

    header("Location: /ticket.php?r=".urlencode($receiptNo));
    exit;
  } catch(Exception $e){
    $error = $e->getMessage();
  }
}

?>
<h4>Cobrar</h4>
<?php if($error): ?><div class="alert alert-danger"><?=h($error)?></div><?php endif; ?>

<div class="card mb-3"><div class="card-body">
  <form method="post">
    <input type="hidden" name="_csrf" value="<?=h(csrf_token())?>">
    <input type="hidden" name="action" value="consult">
    <div class="row g-2">
      <div class="col-md-3">
        <label class="form-label">Consumer ID (Prisma)</label>
        <input class="form-control" name="consumer_id" required value="<?=h($_POST['consumer_id'] ?? '')?>">
      </div>
      <div class="col-md-2">
        <label class="form-label">Tipo Doc</label>
        <select class="form-select" name="document_type">
          <option <?=((($_POST['document_type']??'')==='DNI')?'selected':'')?>>DNI</option>
          <option <?=((($_POST['document_type']??'')==='CUIT')?'selected':'')?>>CUIT</option>
          <option <?=((($_POST['document_type']??'')==='CDI')?'selected':'')?>>CDI</option>
        </select>
      </div>
      <div class="col-md-3">
        <label class="form-label">Nro Documento</label>
        <input class="form-control" name="document_number" required value="<?=h($_POST['document_number'] ?? '')?>">
      </div>
      <div class="col-md-2">
        <label class="form-label">Terminal (texto)</label>
        <input class="form-control" name="terminal_code" value="<?=h($terminals[0]['code'] ?? 'CAJA001')?>">
      </div>
      <div class="col-md-2 d-flex align-items-end">
        <button class="btn btn-primary w-100">Consultar deudas</button>
      </div>
    </div>
    <div class="small text-muted mt-2">
      Consulta por DNI vía Prisma: <code>POST /debts_details</code> (Core Services).
    </div>
  </form>
</div></div>

<?php if (is_array($debts)): ?>
  <div class="card"><div class="card-body">
    <h5>Deudas encontradas: <?=count($debts)?></h5>
    <?php if (!count($debts)): ?>
      <div class="alert alert-info">No hay deudas para este documento (según sandbox/Prisma).</div>
    <?php else: ?>
      <?php foreach($debts as $d): 
        $company = $d['company'] ?? [];
        $cat = $company['category'] ?? [];
      ?>
      <form method="post" class="border rounded p-3 mb-2">
        <input type="hidden" name="_csrf" value="<?=h(csrf_token())?>">
        <input type="hidden" name="action" value="charge">
        <input type="hidden" name="document_type" value="<?=h($_POST['document_type'] ?? 'DNI')?>">
        <input type="hidden" name="document_number" value="<?=h($_POST['document_number'] ?? '')?>">
        <input type="hidden" name="company_id" value="<?=h($company['id'] ?? '')?>">
        <input type="hidden" name="company_name" value="<?=h($company['name'] ?? '')?>">
        <input type="hidden" name="category_id" value="<?=h($cat['id'] ?? ($company['category_id'] ?? ''))?>">
        <input type="hidden" name="category_name" value="<?=h($cat['name'] ?? '')?>">
        <input type="hidden" name="customer_id" value="<?=h($d['client_id'] ?? '')?>">
        <input type="hidden" name="invoice_id" value="<?=h($d['invoice_id'] ?? '')?>">
        <input type="hidden" name="amount" value="<?=h($d['amount'] ?? 0)?>">
        <input type="hidden" name="currency" value="<?=h($d['currency'] ?? 'ARS')?>">
        <input type="hidden" name="due_date" value="<?=h($d['due_date'] ?? '')?>">

        <div class="row g-2">
          <div class="col-md-7">
            <div><b><?=h($company['name'] ?? '—')?></b> <span class="text-muted">(<?=h($cat['name'] ?? '—')?>)</span></div>
            <div class="small text-muted"><?=h($d['screen_description'] ?? '')?></div>
            <div class="small">Invoice: <code><?=h($d['invoice_id'] ?? '')?></code> · ClienteID: <code><?=h($d['client_id'] ?? '')?></code></div>
          </div>
          <div class="col-md-2">
            <div class="text-muted small">Vence</div>
            <div><b><?=h($d['due_date'] ?? '')?></b></div>
          </div>
          <div class="col-md-2">
            <div class="text-muted small">Monto</div>
            <div><b>$ <?=h(number_format((float)($d['amount'] ?? 0), 2, ',', '.'))?></b> <?=h($d['currency'] ?? 'ARS')?></div>
          </div>
          <div class="col-md-1 d-flex align-items-center">
            <div class="w-100">
              <label class="form-label small mb-1">Caja</label>
              <select class="form-select form-select-sm" name="terminal_id" required>
                <option value="">—</option>
                <?php foreach($terminals as $t): ?>
                  <option value="<?=h($t['id'])?>"><?=h($t['code'])?></option>
                <?php endforeach; ?>
              </select>
              <button class="btn btn-success btn-sm w-100 mt-2">Cobrar</button>
            </div>
          </div>
        </div>
      </form>
      <?php endforeach; ?>
    <?php endif; ?>
  </div></div>
<?php endif; ?>

<?php require_once __DIR__ . '/partials/footer.php'; ?>
