<?php
// =====================
// CobroFacil Config
// =====================

// Base
define('APP_NAME', 'CobroFacil');
define('BASE_URL', getenv('COBROFACIL_BASE_URL') ?: 'https://cobrofacil.grupoboing.com.ar');
define('TIMEZONE', 'America/Argentina/Buenos_Aires');

// Seguridad de comprobante (HMAC) - CAMBIAR
define('SECRET_KEY', getenv('COBROFACIL_SECRET_KEY') ?: 'pgTEN_QV8uPB7CoXc0R4QUsBfL_xfMpolRbQ7mBdPB5YieoqpbjSDfI6GBxQgkId');

// DB
define('DB_PATH', __DIR__ . '/data/app.db');

// Prisma (PMC) - Sandbox por defecto
define('PRISMA_CORE_BASE', getenv('PRISMA_CORE_BASE') ?: 'https://api-sandbox.prismamediosdepago.com/v1/pmc_services/core_services');
define('PRISMA_AGENT_BASE', getenv('PRISMA_AGENT_BASE') ?: 'https://api-sandbox.prismamediosdepago.com/v1/pmc_services/agents');

// Auth
// Opción A: Token fijo (manual)
define('PRISMA_BEARER_TOKEN', getenv('PRISMA_BEARER_TOKEN') ?: '');

// Opción B: Obtener token (client_credentials) - Ajustar según tu doc de Prisma.
// Usar tus API keys pública/secreta como client_id/client_secret si corresponde.
define('PRISMA_TOKEN_URL', getenv('PRISMA_TOKEN_URL') ?: ''); // ej: https://.../oauth/token
define('PRISMA_CLIENT_ID', getenv('PRISMA_CLIENT_ID') ?: '');
define('PRISMA_CLIENT_SECRET', getenv('PRISMA_CLIENT_SECRET') ?: '');
define('PRISMA_TOKEN_AUDIENCE', getenv('PRISMA_TOKEN_AUDIENCE') ?: ''); // opcional
define('PRISMA_TOKEN_SCOPE', getenv('PRISMA_TOKEN_SCOPE') ?: '');       // opcional

// Identidad/operación default
define('DEFAULT_CHANNEL', 'WEB');
define('DEFAULT_ORIGIN', 'COBROFACIL');
