<?php
require_once __DIR__ . '/lib/db.php';

// prevent re-install
if (file_exists(__DIR__ . '/data/installed.lock')) {
  die("Ya instalado. Borrá /data/installed.lock para reinstalar (NO recomendado).");
}

$db->exec("
CREATE TABLE IF NOT EXISTS branches (
  id INTEGER PRIMARY KEY AUTOINCREMENT,
  name TEXT NOT NULL,
  address TEXT,
  phone TEXT,
  created_at TEXT NOT NULL
);

CREATE TABLE IF NOT EXISTS users (
  id INTEGER PRIMARY KEY AUTOINCREMENT,
  email TEXT UNIQUE NOT NULL,
  name TEXT NOT NULL,
  password_hash TEXT NOT NULL,
  role TEXT NOT NULL, -- admin, cashier
  branch_id INTEGER,
  is_active INTEGER NOT NULL DEFAULT 1,
  created_at TEXT NOT NULL,
  FOREIGN KEY(branch_id) REFERENCES branches(id)
);

CREATE TABLE IF NOT EXISTS terminals (
  id INTEGER PRIMARY KEY AUTOINCREMENT,
  branch_id INTEGER NOT NULL,
  code TEXT NOT NULL, -- CAJA001
  name TEXT,
  is_active INTEGER NOT NULL DEFAULT 1,
  created_at TEXT NOT NULL,
  UNIQUE(branch_id, code),
  FOREIGN KEY(branch_id) REFERENCES branches(id)
);

CREATE TABLE IF NOT EXISTS receipts (
  id INTEGER PRIMARY KEY AUTOINCREMENT,
  receipt_no TEXT UNIQUE NOT NULL,
  ts TEXT NOT NULL,
  branch_id INTEGER NOT NULL,
  terminal_id INTEGER NOT NULL,
  cashier_user_id INTEGER NOT NULL,
  document_type TEXT NOT NULL,
  document_number TEXT NOT NULL,
  company_id TEXT,
  company_name TEXT,
  category_id TEXT,
  category_name TEXT,
  customer_id TEXT,
  invoice_id TEXT,
  barcode TEXT,
  amount REAL NOT NULL,
  currency TEXT NOT NULL,
  due_date TEXT,
  status TEXT NOT NULL, -- COBRADO_INTERNO, CONFIRMADO_RED, ANULADO
  security_code TEXT NOT NULL,
  prisma_transaction_number TEXT,
  prisma_control_number TEXT,
  prisma_payment_date TEXT,
  raw_debt_json TEXT,
  raw_confirm_json TEXT,
  created_at TEXT NOT NULL,
  FOREIGN KEY(branch_id) REFERENCES branches(id),
  FOREIGN KEY(terminal_id) REFERENCES terminals(id),
  FOREIGN KEY(cashier_user_id) REFERENCES users(id)
);

CREATE TABLE IF NOT EXISTS settings (
  k TEXT PRIMARY KEY,
  v TEXT NOT NULL
);
");

$now = now_iso();
$db->prepare("INSERT INTO branches(name,address,phone,created_at) VALUES (?,?,?,?)")
   ->execute(['Sucursal Central', '—', '—', $now]);
$branchId = (int)$db->lastInsertId();

$db->prepare("INSERT INTO terminals(branch_id,code,name,is_active,created_at) VALUES (?,?,?,?,?)")
   ->execute([$branchId, 'CAJA001', 'Caja 1', 1, $now]);
$terminalId = (int)$db->lastInsertId();

require_once __DIR__ . '/lib/util.php';
$adminEmail = 'admin@cobrofacil.local';
$adminPass  = 'ChangeMe123!';
$adminHash  = password_hash_cf($adminPass);

$db->prepare("INSERT INTO users(email,name,password_hash,role,branch_id,is_active,created_at) VALUES (?,?,?,?,?,?,?)")
   ->execute([$adminEmail,'Administrador',$adminHash,'admin',null,1,$now]);

file_put_contents(__DIR__ . '/data/installed.lock', $now);

?>
<!doctype html><html><head><meta charset="utf-8"><title>Instalado</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet"></head>
<body class="p-4">
<div class="container">
  <h3>✅ CobroFacil instalado</h3>
  <p>Usuario admin: <b><?=h($adminEmail)?></b></p>
  <p>Clave: <b><?=h($adminPass)?></b> (cambiar inmediatamente)</p>
  <a class="btn btn-primary" href="login.php">Ir a Login</a>
</div>
</body></html>
