<?php
require_once __DIR__ . '/db.php';

function next_receipt_no(PDO $db, int $terminalId): string {
  // get terminal code
  $st = $db->prepare("SELECT code FROM terminals WHERE id=?");
  $st->execute([$terminalId]);
  $code = $st->fetchColumn();
  if (!$code) $code = 'CAJA001';

  $date = date('Ymd');
  // count today per terminal
  $like = sprintf("COB-%s-%s-%%", $code, $date);
  $st = $db->prepare("SELECT COUNT(*) FROM receipts WHERE receipt_no LIKE ?");
  $st->execute([$like]);
  $n = (int)$st->fetchColumn() + 1;

  return sprintf("COB-%s-%s-%06d", $code, $date, $n);
}

function security_code(array $r): string {
  $base = implode("|", [
    $r['receipt_no'],
    $r['ts'],
    $r['terminal_id'],
    $r['cashier_user_id'],
    $r['document_type'].$r['document_number'],
    $r['company_id'],
    $r['invoice_id'],
    number_format((float)$r['amount'],2,'.',''),
    $r['currency']
  ]);
  $hmac = hash_hmac('sha256', $base, SECRET_KEY, false);
  return strtoupper(substr($hmac,0,6).'-'.substr($hmac,6,6).'-'.substr($hmac,12,6));
}
