<?php
require_once __DIR__ . '/../config.php';

date_default_timezone_set(TIMEZONE);

function h($s){ return htmlspecialchars((string)$s, ENT_QUOTES, 'UTF-8'); }

function now_iso(){ return date('c'); }

function csrf_token(){
  if (session_status() !== PHP_SESSION_ACTIVE) session_start();
  if (empty($_SESSION['_csrf'])) $_SESSION['_csrf'] = bin2hex(random_bytes(16));
  return $_SESSION['_csrf'];
}
function csrf_check(){
  if (session_status() !== PHP_SESSION_ACTIVE) session_start();
  $t = $_POST['_csrf'] ?? '';
  if (!$t || empty($_SESSION['_csrf']) || !hash_equals($_SESSION['_csrf'], $t)) {
    http_response_code(400);
    die('CSRF inválido');
  }
}

function password_hash_cf($p){ return password_hash($p, PASSWORD_DEFAULT); }
function password_verify_cf($p, $h){ return password_verify($p, $h); }

function require_login(){
  if (session_status() !== PHP_SESSION_ACTIVE) session_start();
  if (empty($_SESSION['user'])) {
    header('Location: /login.php');
    exit;
  }
}
function require_role($role){
  require_login();
  $u = $_SESSION['user'];
  if (($u['role'] ?? '') !== $role) {
    http_response_code(403);
    die('Acceso denegado');
  }
}
