<?php
require_once __DIR__ . '/lib/db.php';
if (session_status() !== PHP_SESSION_ACTIVE) session_start();
$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  csrf_check();
  $email = trim($_POST['email'] ?? '');
  $pass  = $_POST['password'] ?? '';

  $st = $db->prepare("SELECT * FROM users WHERE email=? AND is_active=1");
  $st->execute([$email]);
  $u = $st->fetch(PDO::FETCH_ASSOC);

  if ($u && password_verify_cf($pass, $u['password_hash'])) {
    $_SESSION['user'] = [
      'id' => (int)$u['id'],
      'email' => $u['email'],
      'name' => $u['name'],
      'role' => $u['role'],
      'branch_id' => $u['branch_id']
    ];
    header('Location: /dashboard.php');
    exit;
  } else {
    $error = 'Credenciales inválidas';
  }
}
?>
<!doctype html><html><head><meta charset="utf-8"><title>Login - CobroFacil</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet"></head>
<body class="bg-light">
<div class="container" style="max-width:420px;margin-top:8vh;">
  <div class="card shadow-sm">
    <div class="card-body">
      <h4 class="mb-3">CobroFacil</h4>
      <?php if($error): ?><div class="alert alert-danger"><?=h($error)?></div><?php endif; ?>
      <form method="post">
        <input type="hidden" name="_csrf" value="<?=h(csrf_token())?>">
        <div class="mb-2">
          <label class="form-label">Email</label>
          <input class="form-control" name="email" required>
        </div>
        <div class="mb-3">
          <label class="form-label">Clave</label>
          <input class="form-control" type="password" name="password" required>
        </div>
        <button class="btn btn-primary w-100">Ingresar</button>
      </form>
      <div class="mt-3 small text-muted">
        Si es la primera vez, ejecutá <b>/install.php</b>.
      </div>
    </div>
  </div>
</div>
</body></html>
