<?php
require_once __DIR__ . '/lib/db.php';
require_once __DIR__ . '/partials/header.php';

$from = $_GET['from'] ?? date('Y-m-d');
$to   = $_GET['to'] ?? date('Y-m-d');
$q    = trim($_GET['q'] ?? '');

$sql = "SELECT r.*, t.code as terminal_code, u.name as cashier_name
        FROM receipts r
        JOIN terminals t ON t.id=r.terminal_id
        JOIN users u ON u.id=r.cashier_user_id
        WHERE date(r.ts) BETWEEN ? AND ?";
$args = [$from, $to];
if ($q) {
  $sql .= " AND (r.receipt_no LIKE ? OR r.document_number LIKE ? OR r.invoice_id LIKE ?)";
  $args += ["%$q%","%$q%","%$q%"];
}
$sql .= " ORDER BY r.id DESC LIMIT 500";
$st = $db->prepare($sql);
$st->execute(array_values($args));
$rows = $st->fetchAll(PDO::FETCH_ASSOC);

if (isset($_GET['export']) && $_GET['export']==='csv') {
  header('Content-Type: text/csv; charset=utf-8');
  header('Content-Disposition: attachment; filename="comprobantes.csv"');
  $out = fopen('php://output', 'w');
  fputcsv($out, ['receipt_no','ts','terminal','cashier','document','company','invoice_id','amount','currency','status','prisma_tx','prisma_ctrl']);
  foreach($rows as $r){
    fputcsv($out, [$r['receipt_no'],$r['ts'],$r['terminal_code'],$r['cashier_name'],$r['document_type'].' '.$r['document_number'],$r['company_name'],$r['invoice_id'],$r['amount'],$r['currency'],$r['status'],$r['prisma_transaction_number'],$r['prisma_control_number']]);
  }
  exit;
}
?>
<h4>Comprobantes</h4>

<form class="row g-2 mb-3" method="get">
  <div class="col-md-2">
    <label class="form-label">Desde</label>
    <input class="form-control" type="date" name="from" value="<?=h($from)?>">
  </div>
  <div class="col-md-2">
    <label class="form-label">Hasta</label>
    <input class="form-control" type="date" name="to" value="<?=h($to)?>">
  </div>
  <div class="col-md-4">
    <label class="form-label">Buscar</label>
    <input class="form-control" name="q" value="<?=h($q)?>" placeholder="Comprobante / DNI / invoice_id">
  </div>
  <div class="col-md-2 d-flex align-items-end">
    <button class="btn btn-outline-primary w-100">Filtrar</button>
  </div>
  <div class="col-md-2 d-flex align-items-end">
    <a class="btn btn-outline-success w-100" href="?from=<?=h($from)?>&to=<?=h($to)?>&q=<?=h(urlencode($q))?>&export=csv">Export CSV</a>
  </div>
</form>

<div class="table-responsive">
<table class="table table-sm table-striped">
  <thead><tr>
    <th>Fecha</th><th>Comprobante</th><th>Caja</th><th>Operador</th><th>Cliente</th><th>Servicio</th><th>Monto</th><th>Estado</th><th></th>
  </tr></thead>
  <tbody>
  <?php foreach($rows as $r): ?>
    <tr>
      <td><?=h(substr($r['ts'],0,19))?></td>
      <td><code><?=h($r['receipt_no'])?></code></td>
      <td><?=h($r['terminal_code'])?></td>
      <td><?=h($r['cashier_name'])?></td>
      <td><?=h($r['document_type'].' '.$r['document_number'])?></td>
      <td><?=h($r['company_name'])?></td>
      <td><b>$ <?=h(number_format((float)$r['amount'],2,',','.'))?></b> <?=h($r['currency'])?></td>
      <td><?=h($r['status'])?></td>
      <td><a class="btn btn-sm btn-outline-secondary" href="/ticket.php?r=<?=h(urlencode($r['receipt_no']))?>">Imprimir</a></td>
    </tr>
  <?php endforeach; ?>
  </tbody>
</table>
</div>
<?php require_once __DIR__ . '/partials/footer.php'; ?>
