<?php
require_once __DIR__ . '/lib/db.php';
$r = $_GET['r'] ?? '';
$st = $db->prepare("SELECT r.*, t.code as terminal_code, u.name as cashier_name
                    FROM receipts r
                    JOIN terminals t ON t.id=r.terminal_id
                    JOIN users u ON u.id=r.cashier_user_id
                    WHERE r.receipt_no=?");
$st->execute([$r]);
$rec = $st->fetch(PDO::FETCH_ASSOC);
if(!$rec){ http_response_code(404); die('No encontrado'); }
$verifyUrl = BASE_URL . "/verify.php?r=" . urlencode($rec['receipt_no']) . "&c=" . urlencode($rec['security_code']);
?>
<!doctype html>
<html><head><meta charset="utf-8">
<title>Ticket <?=h($rec['receipt_no'])?></title>
<style>
@page{size:80mm auto;margin:4mm}
body{font-family:Arial,sans-serif;font-size:12px}
.center{text-align:center}.big{font-size:16px;font-weight:800}
.line{border-top:1px dashed #000;margin:6px 0}
.row{display:flex;justify-content:space-between}
.mono{font-family:"Courier New",monospace}
.small{font-size:10px}
</style></head>
<body>
<div class="center big">COBROFACIL</div>
<div class="center small">Comprobante de Cobro Interno</div>
<div class="line"></div>

<div class="row"><div>Fecha</div><div class="mono"><?=h($rec['ts'])?></div></div>
<div class="row"><div>Caja</div><div class="mono"><?=h($rec['terminal_code'])?></div></div>
<div class="row"><div>Operador</div><div class="mono"><?=h($rec['cashier_name'])?></div></div>

<div class="line"></div>
<div><b>Cliente</b>: <?=h($rec['document_type'])?> <?=h($rec['document_number'])?></div>
<div><b>Servicio</b>: <?=h($rec['company_name'])?></div>
<?php if($rec['invoice_id']): ?><div><b>Factura</b>: <span class="mono"><?=h($rec['invoice_id'])?></span></div><?php endif; ?>
<?php if($rec['customer_id']): ?><div><b>Cliente ID</b>: <span class="mono"><?=h($rec['customer_id'])?></span></div><?php endif; ?>

<div class="line"></div>
<div class="row"><div><b>IMPORTE</b></div><div class="mono"><b>$ <?=h(number_format((float)$rec['amount'],2,',','.'))?></b></div></div>
<div class="row"><div>Moneda</div><div class="mono"><?=h($rec['currency'])?></div></div>
<?php if($rec['due_date']): ?><div class="row"><div>Venc.</div><div class="mono"><?=h($rec['due_date'])?></div></div><?php endif; ?>
<div class="row"><div>Estado</div><div class="mono"><?=h($rec['status'])?></div></div>

<div class="line"></div>
<div><b>N°</b>: <span class="mono"><?=h($rec['receipt_no'])?></span></div>
<div><b>Seg.</b>: <span class="mono"><?=h($rec['security_code'])?></span></div>

<div class="center" style="margin-top:8px">
  <img alt="QR" src="https://api.qrserver.com/v1/create-qr-code/?size=160x160&data=<?=urlencode($verifyUrl)?>">
  <div class="small"><?=h($verifyUrl)?></div>
</div>

<div class="line"></div>
<div class="center small">
Conserve este comprobante. El pago se aplica en red al rendir/confirmar.
</div>

<script>window.print()</script>
</body></html>
