<?php
require_once __DIR__ . '/lib/db.php';
require_once __DIR__ . '/lib/receipts.php';

$r = $_GET['r'] ?? '';
$c = $_GET['c'] ?? '';

$st = $db->prepare("SELECT * FROM receipts WHERE receipt_no=?");
$st->execute([$r]);
$rec = $st->fetch(PDO::FETCH_ASSOC);
?>
<!doctype html><html><head><meta charset="utf-8"><title>Verificar</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet"></head>
<body class="p-4 bg-light">
<div class="container" style="max-width:640px">
  <h4>Verificación CobroFacil</h4>
<?php if(!$rec): ?>
  <div class="alert alert-danger">Comprobante inexistente.</div>
<?php else:
  $check = security_code($rec);
  $ok = $c && hash_equals($check, strtoupper($c));
?>
  <?php if($ok): ?>
    <div class="alert alert-success"><b>COMPROBANTE VÁLIDO</b></div>
  <?php else: ?>
    <div class="alert alert-danger"><b>COMPROBANTE INVÁLIDO</b> (código no coincide)</div>
  <?php endif; ?>
  <div class="card"><div class="card-body">
    <div><b>Comprobante:</b> <code><?=h($rec['receipt_no'])?></code></div>
    <div><b>Fecha:</b> <?=h($rec['ts'])?></div>
    <div><b>Cliente:</b> <?=h($rec['document_type'].' '.$rec['document_number'])?></div>
    <div><b>Servicio:</b> <?=h($rec['company_name'])?></div>
    <div><b>Monto:</b> $ <?=h(number_format((float)$rec['amount'],2,',','.'))?> <?=h($rec['currency'])?></div>
    <div><b>Estado:</b> <?=h($rec['status'])?></div>
  </div></div>
<?php endif; ?>

  <div class="mt-3 small text-muted">
    Si necesitás validar manualmente, ingresá <code>?r=COMPROBANTE&c=CODIGO</code>.
  </div>
</div>
</body></html>
